<?php
require 'auth.php';
require 'db.php';

$id = $_GET['id'];
$row = $pdo->prepare("SELECT * FROM players WHERE id = ?");
$row->execute([$id]);
$data = $row->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = $_POST['nama_lengkap'];
    $username_ml = $_POST['username_ml'];
    $id_ml = $_POST['id_ml'];
    $nomor_wa = $_POST['nomor_wa'];
    $role_utama = $_POST['role_utama'];
    $role_cadangan = $_POST['role_cadangan'];
    $lolos_trial = $_POST['lolos_trial'];  // Tambahkan untuk update status trial

    $stmt = $pdo->prepare("UPDATE players SET nama_lengkap=?, username_ml=?, id_ml=?, nomor_wa=?, role_utama=?, role_cadangan=?, lolos_trial=? WHERE id=?");
    $stmt->execute([$nama, $username_ml, $id_ml, $nomor_wa, $role_utama, $role_cadangan, $lolos_trial, $id]);
    header("Location: index.php");
    exit;
}

// Roles array for dropdown options
$roles = ["Jungler", "Gold", "EXP", "Roam", "Mid"];
// Status trial options
$trialStatus = [0 => 'Proses Trial', 1 => 'Lolos', 2 => 'Tidak Lolos'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Edit Data Pemain</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

  <style>
    body {
      background: linear-gradient(135deg, #667eea, #764ba2);
      color: #fff;
      font-family: 'Arial', sans-serif;
      padding: 40px 20px;
    }
    .form-container {
      max-width: 700px;
      margin: 0 auto;
      background: rgba(0, 0, 0, 0.3);
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }
    .card-header {
      background: #3f51b5;
      color: white;
      border-radius: 10px;
    }
    .form-label {
      font-weight: bold;
    }
    .btn-custom {
      background: #28a745;
      color: white;
      border-radius: 50px;
      font-weight: bold;
      transition: background-color 0.3s;
    }
    .btn-custom:hover {
      background: #218838;
    }
    .select2-container .select2-selection {
      border-radius: 8px;
    }
    .form-control, .form-select {
      border-radius: 8px;
      border: 1px solid #ddd;
      padding: 12px;
    }
    .form-control:focus, .form-select:focus {
      border-color: #5c6bc0;
    }
    .icon-btn {
      display: inline-block;
      margin-right: 10px;
    }
    .icon-btn i {
      font-size: 16px;
    }
  </style>
</head>
<body>

<div class="container form-container">
  <div class="card shadow-sm border-0">
    <div class="card-header text-center">
      <h4><i class="fas fa-user-edit me-2"></i>Edit Data Pemain</h4>
    </div>
    <div class="card-body">
      <form method="post">
        <div class="mb-3">
          <label class="form-label">Nama Lengkap</label>
          <input type="text" name="nama_lengkap" value="<?= htmlspecialchars($data['nama_lengkap']) ?>" class="form-control" required />
        </div>
        <div class="mb-3">
          <label class="form-label">Username ML</label>
          <input type="text" name="username_ml" value="<?= htmlspecialchars($data['username_ml']) ?>" class="form-control" required />
        </div>
        <div class="mb-3">
          <label class="form-label">ID ML</label>
          <input type="text" name="id_ml" value="<?= htmlspecialchars($data['id_ml']) ?>" class="form-control" required />
        </div>
        <div class="mb-3">
          <label class="form-label">Nomor WhatsApp</label>
          <input type="text" name="nomor_wa" value="<?= htmlspecialchars($data['nomor_wa']) ?>" class="form-control" required />
        </div>

        <!-- Role Utama & Cadangan -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label class="form-label">Role Utama</label>
            <select class="form-select" name="role_utama" id="role_utama" required>
              <option value="" disabled <?= empty($data['role_utama']) ? 'selected' : '' ?>>Pilih Role</option>
              <?php foreach ($roles as $role): ?>
                <option value="<?= $role ?>" <?= $data['role_utama'] === $role ? 'selected' : '' ?>><?= $role ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Role Cadangan</label>
            <select class="form-select" name="role_cadangan" id="role_cadangan">
              <option value="" disabled <?= empty($data['role_cadangan']) ? 'selected' : '' ?>>Pilih Role</option>
              <?php foreach ($roles as $role): ?>
                <option value="<?= $role ?>" <?= $data['role_cadangan'] === $role ? 'selected' : '' ?>><?= $role ?></option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>

        <!-- Status Trial -->
        <div class="mb-3">
          <label class="form-label">Status Trial</label>
          <select class="form-select" name="lolos_trial" required>
            <option value="" disabled>Pilih Status Trial</option>
            <?php foreach ($trialStatus as $key => $value): ?>
              <option value="<?= $key ?>" <?= $data['lolos_trial'] == $key ? 'selected' : '' ?>><?= $value ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="d-flex justify-content-between">
          <a href="index.php" class="btn btn-secondary icon-btn">
            <i class="fas fa-arrow-left"></i> Kembali
          </a>
          <button type="submit" class="btn btn-custom icon-btn">
            <i class="fas fa-save"></i> Simpan Perubahan
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  const roleUtama = document.getElementById('role_utama');
  const roleCadangan = document.getElementById('role_cadangan');

  function updateDisabledOptions() {
    const utamaVal = roleUtama.value;
    const cadanganVal = roleCadangan.value;

    // Enable all options first
    Array.from(roleUtama.options).forEach(opt => opt.disabled = false);
    Array.from(roleCadangan.options).forEach(opt => opt.disabled = false);

    // Disable option in cadangan that is selected in utama
    if (utamaVal) {
      Array.from(roleCadangan.options).forEach(opt => {
        if (opt.value === utamaVal) opt.disabled = true;
      });
    }
    // Disable option in utama that is selected in cadangan
    if (cadanganVal) {
      Array.from(roleUtama.options).forEach(opt => {
        if (opt.value === cadanganVal) opt.disabled = true;
      });
    }
  }

  roleUtama.addEventListener('change', updateDisabledOptions);
  roleCadangan.addEventListener('change', updateDisabledOptions);

  // Run once on page load to set disabled options based on the initial data
  updateDisabledOptions();
</script>

</body>
</html>
