<?php
require 'auth.php';  // Pastikan sudah login
require 'db.php';    // Koneksi PDO ke database

// Ambil data pemain terbaru
$data = $pdo->query("SELECT * FROM players ORDER BY created_at DESC")->fetchAll();

// Fungsi untuk mendapatkan icon sesuai role
function getRoleIcon($role) {
    switch (strtolower($role)) {
        case 'jungler':
            return '<i class="fas fa-leaf text-success" aria-hidden="true"></i>';
        case 'gold':
            return '<i class="fas fa-coins text-warning" aria-hidden="true"></i>';
        case 'exp':
            return '<i class="fas fa-bolt text-danger" aria-hidden="true"></i>';
        case 'mid':
            return '<i class="fas fa-star text-primary" aria-hidden="true"></i>';
        case 'roam':   // roam diganti tank
            return '<i class="fas fa-shield-alt text-info" aria-hidden="true"></i>';
        default:
            return '<i class="fas fa-question-circle text-secondary" aria-hidden="true"></i>';
    }
}

// Fungsi untuk menampilkan status trial
function getTrialStatus($status) {
    switch ($status) {
        case 1:
            return '<span class="badge bg-success">Lolos</span>';
        case 2:
            return '<span class="badge bg-danger">Tidak Lolos</span>';
        default:
            return '<span class="badge bg-warning">Proses Trial</span>';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Admin Panel - Data Pendaftaran</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

  <style>
    body {
      background: linear-gradient(135deg, #667eea, #764ba2);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      min-height: 100vh;
      display: flex;
      justify-content: center;
      padding: 40px 20px;
      color: #f0f0f5;
    }

    .container {
      background: rgba(255, 255, 255, 0.1);
      border-radius: 20px;
      box-shadow:
        0 8px 32px 0 rgba(31, 38, 135, 0.37),
        0 0 0 1px rgba(255, 255, 255, 0.18);
      padding: 30px 40px;
      max-width: 1000px;
      width: 100%;
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
    }

    .header-bar {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 30px;
      color: #f0f0f5;
    }

    .logo {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .logo img {
      height: 50px;
      border-radius: 8px;
      box-shadow: 0 0 8px rgba(255 255 255 / 0.3);
      transition: transform 0.3s ease;
    }
    .logo img:hover {
      transform: rotate(15deg) scale(1.1);
    }

    table {
      border-collapse: separate;
      border-spacing: 0 12px;
      width: 100%;
      color: #f0f0f5;
    }
    thead tr {
      background: linear-gradient(90deg, #5b21b6, #7c3aed);
      border-radius: 15px;
      color: #f9fafb;
    }
    thead th {
      padding: 15px 20px;
      text-align: left;
      font-weight: 300;
      font-size: 1rem;
      border: none !important;
    }

    tbody tr {
      background: rgba(255 255 255 / 0.15);
      transition: background-color 0.3s ease;
      border-radius: 15px;
      cursor: pointer;
      box-shadow: 0 2px 8px rgba(0 0 0 / 0.1);
      margin-bottom: 10px;
      display: table-row;
    }
    tbody tr:hover {
      background: rgba(255 255 255 / 0.3);
    }
    tbody td {
      padding: 15px 20px;
      vertical-align: middle;
      border: none !important;
      font-size: 0.95rem;
    }

    .btn-primary, .btn-danger {
      border-radius: 50px;
      padding: 6px 14px;
      font-weight: 600;
      box-shadow: 0 3px 8px rgba(0,0,0,0.15);
      transition: all 0.3s ease;
      font-size: 0.9rem;
    }
    .btn-primary {
      background: linear-gradient(90deg, #6366f1, #a78bfa);
      border: none;
      color: #fff;
    }
    .btn-primary:hover {
      background: linear-gradient(90deg, #4338ca, #7c3aed);
      box-shadow: 0 6px 15px rgba(124, 58, 237, 0.6);
      transform: translateY(-2px);
    }
    .btn-danger {
      background: linear-gradient(90deg, #ef4444, #f87171);
      border: none;
      color: #fff;
    }
    .btn-danger:hover {
      background: linear-gradient(90deg, #b91c1c, #fca5a5);
      box-shadow: 0 6px 15px rgba(220, 38, 38, 0.6);
      transform: translateY(-2px);
    }

    .btn-logout {
      background: linear-gradient(90deg, #f59e0b, #fbbf24);
      color: #1e293b;
      font-weight: 700;
      border-radius: 50px;
      padding: 10px 20px;
      box-shadow: 0 3px 10px rgba(251,191,36,0.7);
      transition: all 0.3s ease;
    }
    .btn-logout:hover {
      background: linear-gradient(90deg, #b45309, #f59e0b);
      color: #fafafa;
      box-shadow: 0 6px 20px rgba(180, 83, 9, 0.8);
      transform: translateY(-3px);
    }

    /* Responsif untuk tabel */
    .table-responsive {
      margin-top: 20px;
      overflow-x: auto;
    }

    /* Styling untuk status trial di bawah nama lengkap */
    .trial-status {
      font-size: 0.85rem;
      margin-top: 5px;
    }

    /* Styling tombol WhatsApp */
    .whatsapp-btn {
      margin-top: 10px;
      padding: 5px 10px;
      background-color: #25d366;
      color: #fff;
      font-size: 0.9rem;
      border-radius: 25px;
      text-decoration: none;
    }
    .whatsapp-btn:hover {
      background-color: #128c7e;
    }

  </style>
</head>
<body>
  <div class="container" role="main">
    <header class="header-bar" role="banner">
      <div class="logo">
        <img src="https://skyzo.alfagmr.my.id/skyzo.png" alt="Skyzo Logo" />
        <h2>Admin Panel - Data Pendaftaran Pemain</h2>
      </div>
      <a href="logout.php" class="btn btn-logout" aria-label="Logout">
        <i class="fas fa-sign-out-alt"></i> Logout
      </a>
    </header>

    <!-- Tabel dengan kelas table-responsive untuk membuat tabel bisa digulir -->
    <div class="table-responsive">
      <table role="table" aria-label="Data Pendaftaran Pemain">
        <thead role="rowgroup">
          <tr role="row">
            <th role="columnheader">Nama Lengkap</th>
            <th role="columnheader">Username ML</th>
            <th role="columnheader">ID ML</th>
            <th role="columnheader">Nomor WA</th>
            <th role="columnheader">Role Utama / Cadangan</th>
            <th role="columnheader">Aksi</th>
          </tr>
        </thead>
        <tbody role="rowgroup">
          <?php foreach ($data as $row): ?>
            <tr role="row" tabindex="0" title="Klik untuk melihat detail">
              <td>
                <?= htmlspecialchars($row['nama_lengkap']) ?>
                <div class="trial-status">
                  <?= getTrialStatus($row['lolos_trial']) ?>
                </div>
              </td>
              <td><?= htmlspecialchars($row['username_ml']) ?></td>
              <td><?= htmlspecialchars($row['id_ml']) ?></td>
<td>
    <?php if ($row['lolos_trial'] == 1): // Cek jika pemain lolos ?>
        <!-- Tombol WhatsApp dengan pesan otomatis hanya jika lolos -->
        <a href="https://wa.me/+62<?= htmlspecialchars($row['nomor_wa']) ?>?text=Halo%20<?= urlencode($row['nama_lengkap']) ?>,%0A%0A%F0%9F%93%8D%20Selamat%20Anda%20telah%20lolos%20dalam%20proses%20seleksi%20trial%20kami%20di%20Skyzo%20Esports.%0A%0A%F0%9F%93%8D%20Berikut%20adalah%20informasi%20tentang%20dirimu:%0A%0A%F0%9F%93%8D%20Nama%20Lengkap%20:<?= urlencode($row['nama_lengkap']) ?>%0A%F0%9F%93%8D%20Username%20ML%20:<?= urlencode($row['username_ml']) ?>%0A%F0%9F%93%8D%20ID%20ML%20:<?= urlencode($row['id_ml']) ?>%0A%F0%9F%93%8D%20Nomor%20WA%20:<?= urlencode($row['nomor_wa']) ?>%0A%F0%9F%93%8D%20Role%20Utama%20:<?= urlencode($row['role_utama']) ?>%0A%F0%9F%93%8D%20Role%20Cadangan%20:<?= urlencode($row['role_cadangan']) ?>%0A%F0%9F%93%8D%20Usia%20:<?= urlencode($row['usia']) ?>%0A%0A%F0%9F%93%8D%20Kami%20mengundang%20Anda%20untuk%20bergabung%20dalam%20grup%20WhatsApp%20kami%20untuk%20pembahasan%20lanjutan%20dan%20informasi%20lebih%20detail.%0A%0A%F0%9F%9A%80%20%5BKlik%20untuk%20Bergabung%20di%20Grup%20WhatsApp%5D(https://chat.whatsapp.com/CIRvPcm4uSc5Xtee8DTZXG)%0A%0A%F0%9F%93%8D%20Terima%20Kasih%20atas%20partisipasi%20Anda%20dan%20selamat%20bergabung%20dalam%20tim%20kami.%0A%0A%F0%9F%94%B4%20Salam%20Tim%20Seleksi%20Trial%20Skyzo%20Esports" 
           target="_blank" class="btn btn-success btn-sm" style="text-decoration: none; padding: 6px 14px; font-size: 0.9rem;">
            <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
        </a>
    <?php else: ?>
        <!-- Tampilkan nomor WA dalam bentuk teks biasa jika tidak lolos -->
        <?= htmlspecialchars($row['nomor_wa']) ?>
    <?php endif; ?>
</td>
<td><?= htmlspecialchars($row['usia']) ?> Tahun</td> <!-- Menampilkan umur pemain -->

              <td>
                <?= getRoleIcon($row['role_utama']) ?> <?= htmlspecialchars($row['role_utama']) ?>
                /
                <?= getRoleIcon($row['role_cadangan']) ?> <?= htmlspecialchars($row['role_cadangan']) ?>
              </td>
              <td>
                <a href="edit.php?id=<?= $row['id'] ?>" class="btn btn-primary btn-sm" aria-label="Edit <?= htmlspecialchars($row['nama_lengkap']) ?>">
                  <i class="fas fa-pen"></i> Edit
                </a>
                <a href="delete.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus data ini?')" aria-label="Hapus <?= htmlspecialchars($row['nama_lengkap']) ?>">
                  <i class="fas fa-trash"></i> Hapus
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
