<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->query->message) && !empty($data->query->sender)) {
    require 'db.php';

    $message = strtolower(trim($data->query->message));
    $reply = "⚠️ Format salah. Gunakan:\n• cek id 12345678";

    if (preg_match('/^cek id\s+(\d+)$/i', $message, $matches)) {
        $id_ml = trim($matches[1]);

        $stmt = $pdo->prepare("SELECT * FROM players WHERE id_ml = ?");
        $stmt->execute([$id_ml]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $reply = "✅ Data ditemukan:\n";
            $reply .= "• Nama: " . $row['nama_lengkap'] . "\n";
            $reply .= "• Nickname: " . $row['username_ml'] . "\n";
            $reply .= "• ID ML: " . $row['id_ml'] . "\n";
            $reply .= "• Rank Saat Ini: " . $row['rank_saat_ini'] . "\n";
            $reply .= "• High Rank: " . $row['high_rank'] . "\n";
            $reply .= "• Role Utama: " . $row['role_utama'] . "\n";
            $reply .= "• Role Cadangan: " . $row['role_cadangan'];
        } else {
            $reply = "❌ ID ML $id_ml belum terdaftar.";
        }
    }

    echo json_encode([
        "replies" => [
            ["message" => $reply]
        ]
    ], JSON_UNESCAPED_UNICODE);
} else {
    http_response_code(400);
    echo json_encode([
        "replies" => [
            ["message" => "⚠️ Permintaan tidak valid. Gunakan:\n• cek id 12345678"]
        ]
    ]);
}
