<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->query->message) && !empty($data->query->sender)) {
    require 'db.php';

    $message = strtolower(trim($data->query->message));
    $reply = "❌ Perintah tidak dikenal. Ketik: Roaster atau Roaster Hari Ini";

    // Emoji untuk tiap role
    $roleEmojis = [
        'Jungler' => '🍃',
        'Gold'    => '🪙',
        'EXP'     => '🗡️',
        'Mid'     => '🔮',
        'Roam'    => '🛡️'
    ];

    // Fungsi format data pemain
    function formatPlayer($row) {
        return
            "• Nama       : {$row['nama_lengkap']}\n" .
            "• Nickname   : {$row['nickname_ml']}\n" .
            "• ID ML      : {$row['id_ml']}\n" .
            "• No WA      : {$row['whatsapp']}\n" .
            "• Role Cadangan: {$row['role_cadangan']}\n";
    }

    // Jika user ketik "Roaster Hari Ini"
    if ($message === 'roaster hari ini') {
        $roles = ['Jungler', 'Gold', 'EXP', 'Mid', 'Roam'];
        $reply = "📅 *Roaster Hari Ini*\n\n";

        foreach ($roles as $role) {
            $emoji = $roleEmojis[$role] ?? '';
            $stmt = $pdo->prepare("SELECT nama_lengkap, nickname_ml, id_ml, whatsapp, role_cadangan 
                                   FROM roaster_skyzo 
                                   WHERE LOWER(role_utama) = LOWER(?)");
            $stmt->execute([$role]);
            $players = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $reply .= "{$emoji} *$role*\n";

            if ($players && count($players) > 0) {
                $chosen = $players[array_rand($players)];
                $reply .= formatPlayer($chosen) . "\n";
            } else {
                $reply .= "❌ Tidak ada pemain untuk role ini.\n\n";
            }

            $reply .= "--------------------------\n";
        }
    }

    echo json_encode([
        "replies" => [
            ["message" => $reply]
        ]
    ], JSON_UNESCAPED_UNICODE);

} else {
    http_response_code(400);
    echo json_encode([
        "replies" => [
            ["message" => "⚠️ Permintaan tidak valid. Ketik: Roaster atau Roaster Hari Ini"]
        ]
    ]);
}
?>
