<?php
header("Content-Type: application/json; charset=UTF-8");

// Masukkan file koneksi database
require 'db.php';

try {
    // Query untuk hitung total player
    $stmt = $pdo->query("SELECT COUNT(*) AS total FROM players");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $totalPlayers = (int)$row['total'];

    // Output JSON
    echo json_encode([
        'total_players' => $totalPlayers
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error' => "Database error: " . $e->getMessage()
    ]);
}
